#include <bits/stdc++.h>
using namespace std;

typedef vector<bool> vb;
typedef vector<vb> vvb;


int columns, rows, sc, sr, ec, er, result;
// sc - ship column, sr - ship row
// ec - exit column, er - exit row

vvb input(){
    scanf("%d %d\n%d %d\n%d %d", &columns, &rows, &sc, &sr, &ec, &er);
    vvb grid;
    grid.resize(rows, vb(columns, false));
    return grid;
}

void output(){
    printf("%d\n", result);
}

void displayGrid(vvb grid){
    printf("\nGrid:\n");
    for(int i = 0; i < rows; i ++){
        for(auto el : grid[i]){
            printf("%s ", el ? "true" : "false");
        }
        printf("\n");
    }
}

struct Square{
    int row, col, dist;
};

void displaySquare(Square square){
    printf("\nSquare: (%d, %d) and distance: %d\n", square.row, square.col, square.dist);
}

int getMinDistance(vvb grid){
    Square start;
    start.row = sr; start.col = sc; start.dist = 0;

    queue<Square> q;
    q.push(start);
    grid[sr][sc] = true;

    while(!q.empty()){
        Square cur = q.front();
        q.pop();
        int row, column;
        row = cur.row; column = cur.col;
        Square next;

        // Reached the exit;
        if (row == er && column == ec){
            return cur.dist;
        }

        // Up
        if(row - 1 < 0){
            if(grid[rows - 1][column] == false){
                next.col = column; next.dist = cur.dist + 1;
                next.row = rows - 1;
                grid[rows - 1][column] = true;
                q.push(next);
            }
        } else if(grid[row - 1][column] == false){
            next.col = column; next.dist = cur.dist + 1;
            next.row = row - 1;
            grid[row - 1][column] = true;
            q.push(next);
        }

        // Down
        if(row + 1 >= rows){
            if(grid[0][column] == false){
                next.col = column; next.dist = cur.dist + 1;
                next.row = 0;
                grid[0][column] = true;
                q.push(next);
            }
        } else if(grid[row + 1][column] == false){
            next.col = column; next.dist = cur.dist + 1;
            next.row = row + 1;
            grid[row + 1][column] = true;
            q.push(next);
        }

        // Left
        if(column - 1 < 0){
            if(grid[row][columns - 1] == false){
                next.row = row; next.dist = cur.dist + 1;
                next.col = columns - 1;
                grid[row][columns - 1] = true;
                q.push(next);
            }
        } else if(grid[row][column - 1] == false){
            next.row = row; next.dist = cur.dist + 1;
            next.col = column - 1;
            grid[row][column - 1] = true;
            q.push(next);
        }

        // Right
        if(column + 1 >= columns){
            if(grid[row][0] == false){
                next.row = row; next.dist = cur.dist + 1;
                next.col = 0;
                grid[row][0] = true;
                q.push(next);
            }
        } else if(grid[row][column + 1] == false){
            next.row = row; next.dist = cur.dist + 1;
            next.col = column + 1;
            grid[row][column + 1] = true;
            q.push(next);
        }
    }
    return -1;
}


int main()
{
    vvb grid = input();
    result = getMinDistance(grid);
    output();

    return 0;
}